package com.bitbof.escape.entities;

import java.util.LinkedList;
import java.util.List;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;

public class Player implements Entity {

	public World world;
	
	public float health = 1;
	public Vector2f pos, v, a;
	public float width, height;
	public boolean alive = true;
	public float power = 1;

	public ElasticBand band;
	
	public List<ElasticHook> hooks = new LinkedList<ElasticHook>();
	
	public Player(World world) {
		this.world = world;
		pos = new Vector2f(0, 0);
		v = new Vector2f(0, 0);
		a = new Vector2f(0, 0);
		width = 40;
		height = 40;

		band = new ElasticBand(world, this, 0, 0);
	}

	@Override
	public void tick() {
		boolean active = false;
		if (Keyboard.isKeyDown(Keyboard.KEY_LEFT)) {
			a.x = -2*power;
			active = true;
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_RIGHT)) {
			a.x = 2*power;
			active = true;
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_UP)) {
			a.y = 2*power;
			active = true;
		}
		if (Keyboard.isKeyDown(Keyboard.KEY_DOWN)) {
			a.y = -2*power;
			active = true;
		}
		if (a.length() > 2) {
			a.normalise();
			a.x *= 2*power;
			a.y *= 2*power;
		}
		if(active) {
			if(band != null)
				power *= 0.99;
		}
		else {
			power = (float) Math.min(1, power + 0.1);
		}
		
		Vector2f bandForce= new Vector2f(0,0);
		if(band != null) {
			band.tick();
			bandForce= new Vector2f(band.force);
		}
		v.x += a.x + bandForce.x;
		v.y += a.y + bandForce.y;
		if(band != null)
			v.y -= 1;
		
		if (v.length() > 100) {
			v.normalise();
			v.x *= 100;
			v.y *= 100;
		}
		
		pos.x += v.x;
		pos.y += v.y;
		int border = 800;
		if(pos.x < border) {
			pos.x = border;
		}
		if(pos.y > -border)
			pos.y = -border;
		if(pos.x > World.LEVEL_SCALE*512-border)
			pos.x = World.LEVEL_SCALE*512-border;
		if(pos.y < -World.LEVEL_SCALE*512+border)
			pos.y = -World.LEVEL_SCALE*512+border;
		
		a.x *= 0.4;
		a.y *= 0.4;
		v.x *= 0.96;
		v.y *= 0.96;

	}

	@Override
	public void render() {
		
		/*for(ElasticHook h: hooks) {
			h.render();
		}*/
		
		GL11.glPushMatrix();
		Art.ball.bind();
		Texture texture = Art.ball;
		GL11.glColor4f(1, 1, 1, 1);
		GL11.glTranslatef(pos.x, pos.y, 0);
		GL11.glRotatef(1, 0, 0, 0);

		GL11.glScalef(width, height, 0);

		GL11.glBegin(GL11.GL_QUADS);
		GL11.glTexCoord2f(0, 0);
		GL11.glVertex2f(-0.5f, -0.5f);
		GL11.glTexCoord2f(0, texture.getHeight());
		GL11.glVertex2f(0.5f, -0.5f);
		GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
		GL11.glVertex2f(0.5f, 0.5f);
		GL11.glTexCoord2f(texture.getWidth(), 0);
		GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();

		GL11.glPopMatrix();
		
		
	}

	@Override
	public boolean isAlive() {
		return alive;
	}

}
